#include "stm32f10x.h"
#include <stdio.h>
#include "wiz_platform.h"
#include "wizchip_conf.h"
#include "wiz_interface.h"
#include "snmp_custom.h"

/*wizchip->STM32 Hardware Pin define*/
//	wizchip_SCS    --->     STM32_GPIOD7
//	wizchip_SCLK	 --->     STM32_GPIOB13
//  wizchip_MISO	 --->     STM32_GPIOB14
//	wizchip_MOSI	 --->     STM32_GPIOB15
//	wizchip_RESET	 --->     STM32_GPIOD8
//	wizchip_INT    --->     STM32_GPIOD9

/* The current routine uses a 12Mhz external crystal. If you use other crystals, you need to modify the system clock.
******************************************************************************
* stm32f10x.h			Modify 118 lines of external crystal frequency
* system_stm32f10x.c	Modify 1055 lines of frequency doubling factor
#endif
******************************************************************************
*/

#define SOCKET_ID 0
#define ETHERNET_BUF_MAX_SIZE (1024 * 2)

/* network information */
wiz_NetInfo default_net_info = {
    .mac = {0x00, 0x08, 0xdc, 0x12, 0x22, 0x12},
    .ip = {192, 168, 1, 30},
    .gw = {192, 168, 1, 1},
    .sn = {255, 255, 255, 0},
    .dns = {8, 8, 8, 8},
    .dhcp = NETINFO_DHCP}; 
uint8_t ethernet_buf[ETHERNET_BUF_MAX_SIZE] = {0};
uint8_t manager[4] = {192, 168, 1, 20}; // manager ip, (is your pc ip or others managers)

int main(void)
{
	wiz_NetInfo net_info;
	delay_init();
    debug_usart_init();
    wiz_timer_init();
    wiz_spi_init();
    wiz_rst_int_init();
    user_led_init();
    printf("%s SNMP example\r\n",_WIZCHIP_ID_);

	/* wizchip init */
	wizchip_initialize();

	network_init(ethernet_buf, &default_net_info);

	user_led_control_init(get_user_led_status, set_user_led_status);
	
    wizchip_getnetinfo(&net_info);
    snmpd_init(manager, net_info.ip, SOCKET_ID, SOCKET_ID + 1); // Initialize SNMP and corresponding sockets
    while (1)
    {
        snmpd_run(); // Running SNMP
    }
}
