#include <stdint.h>
#include <stdbool.h>

#define TCPS_EN               1
#define NDA                   1
#define RTLVERSiON            227
#define ETHERNET_BUF_MAX_SIZE (1024 * 8)

/* Port */
#define PORT_IPERF     5007
#define MAX_RESULT_LEN 1024
#define SOCKET_CTRL    0
#define SOCKET_DATA    1
/* Cookie size */
#define COOKIE_SIZE 37

/* iperf3 Commands */
#define PARAM_EXCHANGE   9
#define CREATE_STREAMS   10
#define TEST_START       1
#define TEST_RUNNING     2
#define TEST_END         4
#define EXCHANGE_RESULTS 13
#define DISPLAY_RESULTS  14
#define IPERF_DONE       16

// 定义管理计时器和数据统计的结构体
typedef struct {
    uint32_t pacing_timer_ms;  // 计时器周期（微秒单位）
    bool running;              // 执行与否标志
    uint32_t t0;               // 测试开始时间
    uint32_t t1;               // 最后更新时间
    uint32_t t3;               // 测试结束时间
    uint32_t nb0;              // 总字节数
    uint32_t nb1;              // 周期内字节数
    uint32_t np0;              // 总数据包数
    uint32_t np1;              // 周期内数据包数
} Stats;

void stats_init(Stats *stats, uint32_t pacing_timer_ms);
void stats_start(Stats *stats);
void stats_update(Stats *stats, bool final);
void stats_stop(Stats *stats);
void stats_add_bytes(Stats *stats, uint32_t n);
void MX_TIM2_Init(void);
void handle_param_exchange(uint8_t socket_ctrl, bool *reverse, bool *udp);
void handle_create_streams(uint8_t socket_ctrl, bool udp, uint8_t *remote_ip, uint16_t *remote_port);
void start_iperf_test(uint8_t socket_ctrl, uint8_t socket_data, Stats *stats, bool reverse, bool udp, uint8_t *remote_ip, uint16_t *remote_port);
void exchange_results(uint8_t socket_ctrl, Stats *stats);
