/**
  ******************************************************************************
  * @file    mass_mal.c
  * @author  none
  * @version V4.1.0
  * @date    17-Oct-2024
  * @brief   Medium Access Layer interface
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; copyright (c) 2024 WIZnet. 
  * All rights reserved.</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without 
  * modification, are permitted, provided that the following conditions are met:
  *
  * 1. Redistribution of source code must retain the above copyright notice, 
  *    this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright notice,
  *    this list of conditions and the following disclaimer in the documentation
  *    and/or other materials provided with the distribution.
  * 3. Neither the name of WIZnet nor the names of other 
  *    contributors to this software may be used to endorse or promote products 
  *    derived from this software without specific written permission.
  * 4. This software, including modifications and/or derivative works of this 
  *    software, must execute solely and exclusively on microcontroller or
  *    microprocessor devices manufactured by or for WIZnet.
  * 5. Redistribution and use of this software other than as permitted under 
  *    this license is void and will automatically terminate your rights under 
  *    this license. 
  *
  * THIS SOFTWARE IS PROVIDED BY WIZnet AND CONTRIBUTORS "AS IS" 
  * AND ANY EXPRESS, IMPLIED OR STATUTORY WARRANTIES, INCLUDING, BUT NOT 
  * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
  * PARTICULAR PURPOSE AND NON-INFRINGEMENT OF THIRD PARTY INTELLECTUAL PROPERTY
  * RIGHTS ARE DISCLAIMED TO THE FULLEST EXTENT PERMITTED BY LAW. IN NO EVENT 
  * SHALL WIZnet OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
  * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
  * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "platform_config.h"
#include "mass_mal.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
extern t_Mal_Lun  Internal_Flash;
extern t_Mal_Lun  w25qxx_Flash;
extern t_Mal_Lun  SD_Flash;
extern uint8_t    Standard_Inquiry_Data[];
t_Mal_Lun * const Mal_lun[MAX_LUN_NUM] = {&Internal_Flash};

uint32_t Mass_Block_Size[MAX_LUN_NUM];
uint32_t Mass_Block_Count[MAX_LUN_NUM];
uint32_t Max_Lun = MAX_LUN_NUM - 1;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : MAL_Init
* Description    : Initializes the Media on the wiz
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
uint16_t MAL_Init(uint8_t lun)
{
    if (lun >= MAX_LUN_NUM)
        return MAL_FAIL;
    return Mal_lun[lun]->Init();
}
/*******************************************************************************
* Function Name  : MAL_Write
* Description    : Write sectors
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
uint16_t MAL_Write(uint8_t lun, uint32_t Memory_Offset, uint32_t *Writebuff, uint16_t Transfer_Length)
{
    if (lun >= MAX_LUN_NUM)
        return MAL_FAIL;
    return Mal_lun[lun]->Write(Memory_Offset, (uint8_t *)Writebuff, Transfer_Length);
}

/*******************************************************************************
* Function Name  : MAL_Read
* Description    : Read sectors
* Input          : None
* Output         : None
* Return         : Buffer pointer
*******************************************************************************/
uint16_t MAL_Read(uint8_t lun, uint32_t Memory_Offset, uint32_t *Readbuff, uint16_t Transfer_Length)
{
    if (lun >= MAX_LUN_NUM)
        return MAL_FAIL;
    return Mal_lun[lun]->Read(Memory_Offset, (uint8_t *)Readbuff, Transfer_Length);
}

/*******************************************************************************
* Function Name  : MAL_GetStatus
* Description    : Get status
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
uint16_t MAL_GetStatus(uint8_t lun)
{
    if (lun >= MAX_LUN_NUM)
        return MAL_FAIL;
    return Mal_lun[lun]->GetStatus(lun);
}

/*******************************************************************************
* Function Name  : MAL_Standard_Inquiry_Data
* Description    : Get Inquiry Data
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
uint8_t *MAL_Standard_Inquiry_Data(uint8_t lun)
{
    if (lun >= MAX_LUN_NUM)
        return Standard_Inquiry_Data;
    return Mal_lun[lun]->Inquiry_Data;
}


/************************ (C) COPYRIGHT  2024  WIZnet *****END OF FILE****/

