#include "stm32f10x.h"
#include <stdio.h>
#include "wiz_platform.h"
#include "wizchip_conf.h"
#include "wiz_interface.h"

/*wizchip->STM32 Hardware Pin define*/
//	wizchip_SCS    --->     STM32_GPIOD7
//	wizchip_SCLK	 --->     STM32_GPIOB13
//  wizchip_MISO	 --->     STM32_GPIOB14
//	wizchip_MOSI	 --->     STM32_GPIOB15
//	wizchip_RESET	 --->     STM32_GPIOD8
//	wizchip_INT    --->     STM32_GPIOD9

/* The current routine uses a 12Mhz external crystal. If you use other crystals, you need to modify the system clock.
******************************************************************************
* stm32f10x.h			Modify 118 lines of external crystal frequency
* system_stm32f10x.c	Modify 1055 lines of frequency doubling factor
#endif
******************************************************************************
*/

#define ETHERNET_BUF_MAX_SIZE (1024 * 2)

/* network information */
wiz_NetInfo default_net_info = {
    .mac = {0x00, 0x08, 0xdc, 0x12, 0x22, 0x12},
    .ip = {192, 168, 1, 30},
    .gw = {192, 168, 1, 1},
    .sn = {255, 255, 255, 0},
    .dns = {8, 8, 8, 8},
    .dhcp = NETINFO_DHCP}; 
uint8_t ethernet_buf[ETHERNET_BUF_MAX_SIZE] = {0};

int main(void)
{
	wiz_PhyConf phy_conf, get_conf;
	delay_init();
    debug_usart_init();
    wiz_timer_init();
    wiz_spi_init();
    wiz_rst_int_init();
    printf("%s DHCP example\r\n",_WIZCHIP_ID_);

	/* wizchip init */
	wizchip_initialize();

	network_init(ethernet_buf, &default_net_info);

	/* config init massage */
    phy_conf.by = PHY_CONFBY_SW;       // Use software config
    phy_conf.mode = PHY_MODE_MANUAL;   // User config mode
    phy_conf.duplex = PHY_DUPLEX_FULL; // Full duplex
    phy_conf.speed = PHY_SPEED_100;    // Speed

    /* setting phy 100M and full-duplex mode */
    printf("setting phy 100M and full-duplex mode\r\n");
    ctlwizchip(CW_SET_PHYCONF, &phy_conf);
    ctlwizchip(CW_GET_PHYCONF, &get_conf);

    printf("The current Mbtis speed : %d\r\n", get_conf.speed == PHY_SPEED_100 ? 100 : 10);
    printf("The current Duplex Mode : %s\r\n", get_conf.duplex == PHY_DUPLEX_HALF ? "Half-Duplex" : "Full-Duplex");
    delay_s(10);
    /* setting phy 10M and half-duplex mode */
    printf("setting phy 10M and half-duplex mode\r\n");
    phy_conf.speed = PHY_SPEED_10;
    phy_conf.duplex = PHY_DUPLEX_HALF;
    ctlwizchip(CW_SET_PHYCONF, &phy_conf);
    ctlwizchip(CW_GET_PHYCONF, &get_conf);

    printf("The current Mbtis speed : %d\r\n", get_conf.speed == PHY_SPEED_100 ? 100 : 10);
    printf("The current Duplex Mode : %s\r\n", get_conf.duplex == PHY_DUPLEX_HALF ? "Half-Duplex" : "Full-Duplex");
    delay_s(10);
    /* setting phy low power mode */
    printf("setting phy low power mode\r\n");
    wizphy_setphypmode(PHY_POWER_DOWN);
    printf("The current phy is : %s\r\n", (getPHYCFGR() & PHYCFGR_OPMDC_PDOWN) ? "power down mode" : "normal mode");
    printf("PHY is in power down state and cannot be ping reply.\r\n");
    while (1)
    {
    }
}
