#include "wol.h"
#include <stdio.h>
#include "socket.h"

/**
 * @brief  Wake on Lan run function
 * @param  sn: Socket number
 * @param  buf: ethernet buffer pointer
 * @param  local_port: Local port
 * @return none
 **/
void wol_run(uint8_t sn, uint8_t *buf, uint16_t local_port)
{
    uint16_t len = 0;
    uint8_t remote_ip[4] = {0};
    uint16_t remote_port = 0;
    switch (getSn_SR(sn))
    {
    case SOCK_UDP:
        if (getSn_IR(sn) & Sn_IR_RECV)
        {
            setSn_IR(sn, Sn_IR_RECV);
        }
        if (getIR() & 0x10) // Received WOL Magic packet based on UDP.
        {
            printf("get wake on line\r\n");
            setIR(0x10);
        }
        if ((len = getSn_RX_RSR(sn)) > 0) // Determine if a message has been received
        {
            recvfrom(sn, buf, len, remote_ip, &remote_port); // Receive Data
            printf("%s", buf);
            sendto(sn, buf, len, remote_ip, remote_port); // Send Data
        }
        break;
    case SOCK_CLOSED:
        socket(sn, Sn_MR_UDP, local_port, 0);
        setIMR(IM_IR4);     // Open WOL magic pack interrupt
        setMR(MR_WOL); // Receive WOL packets
        printf("%d:Opened, UDP WOL, port [%d]\r\n", sn, local_port);
        break;
    }
}
